# 星聚合登录 PHP SDK

## 使用方法

### 1. 引入SDK
```php
require 'OAuth.php';
```

### 2. 初始化
```php
$config = [
    'apiurl' => 'https://login.xingqingchuang.com', // 聚合登录API地址
    'appid' => '1000', // 应用ID
    'appkey' => 'xxxxxx', // 应用密钥
    'callback' => 'http://your-site.com/callback.php' // 回调地址
];
$oauth = new OAuth($config);
```

### 3. 发起登录
```php
// type: 登录方式，如 qq, wx, sina 等
$res = $oauth->login($type);
if($res['code'] == 0){
    header('Location: ' . $res['url']);
    exit;
}else{
    echo $res['msg'];
}
```

### 4. 获取用户信息
在回调页面中：
```php
$code = $_GET['code'];
if($code){
    $res = $oauth->callback($code);
    if($res['code'] == 0){
        print_r($res);
        // $res 包含: social_uid, nickname, faceimg, gender, etc.
    }else{
        echo $res['msg'];
    }
}
```

## 支持的登录方式 (type)

| 平台 | 代码 (type) | 说明 |
| --- | --- | --- |
| QQ | `qq` | |
| 微信扫码 | `wx` | 开放平台 |
| 微信公众号 | `wechat` | 服务号 |
| 微博 | `sina` | |
| 支付宝 | `alipay` | |
| GitHub | `github` | |
| Google | `google` | |
| Gitee | `gitee` | |
| 百度 | `baidu` | |
| 抖音 | `douyin` | |
| 微软 | `microsoft` | |
| 小米 | `xiaomi` | |
| 钉钉 | `dingtalk` | |
| 飞书 | `feishu` | |
| Steam | `steam` | |
| X (Twitter) | `x` | |
| Facebook | `facebook` | |
| Line | `line` | |
| Apple | `apple` | |
| Instagram | `instagram` | |
| LinkedIn | `linkedin` | |
